/** @file   UltimateBadAssAi.h
 * @brief   Declaration of UltimateBadAssAi class.
 * @version $Revision: 1.1 $
 * @date    $Date: 2006/07/13 16:25:09 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_ULTIMATEBADASSAI_H
#define H_WWW_ULTIMATEBADASSAI_H

#include "aicontroller.h"

namespace WeWantWar {

/** @class  BadAssAi
 * @brief   Contains the logic that controls the LightballAlien
 * @author  Tomi Lamminsaari
 *
 */
class UltimateBadAssAi : public AIController
{
public:

  ///
  /// Constants, datatypes and static methods
  /// =======================================

  ///
  /// Constructors, destructor and operators
  /// ======================================

  /** Default constructor.
   * @param   aObject           Pointer to GameObject whom we are controlling.
   */
  UltimateBadAssAi( GameObject* aObject );

  /** Destructor
   */
  ~UltimateBadAssAi();

private:
  UltimateBadAssAi( const UltimateBadAssAi& aAnother );
  UltimateBadAssAi& operator= ( const UltimateBadAssAi& aAnother );
public:

  ///
  /// Inherited methods
  /// =================

  /** Updates this controller.
   * @param   aSeeTarget        Tells if we can see our target.
   * @param   aDistance         Distance to our target.
   */
  virtual void updateAI( bool aSeeTarget, float aDistance );
  
  /** Sets the alerted mode on/off.
   * @param aAlerted            Alerted-flag status
   */
  void setAlerted(bool aAlerted);
  
  enum AlienState {
    EAlienStateAttack,
    EAlienStateMove,
    EAlienStateEvade
  };
  AlienState currentAiState() const;

protected:
  
  
  void updateAttackState();
  void updateMoveState();
  ///
  /// Data members
  /// ============

  /** Tells if we're in alerted mode. */
  bool      iAlerted;
  
  /** THe previous player position is stored here. */
  eng2d::Vec2D  iLastKnownPos;
  
  /** The logic state */
  AlienState  iAlienState;
  int iStateCounter;
  eng2d::Vec2D iDestCoord;
  int iSameStateCounter;
};

};  // end of namespace

#endif
